_G.EXPOK = _G.EXPOK or {}
EXPOK._path = ModPath
EXPOK._data_path = SavePath .. "EXPOK_data.txt"
EXPOK._data = {
	exp_text_duration = 5,
	kln_duration = 2,
	show_announcer = true,
	exp_font_size = 15,
	kln_font_size = 15,
	exp_adjust_x = 0,
	exp_adjust_y = 0,
	kln_adjust_x = 0,
	kln_adjust_y = 0,
	gain_exp_on_kills = true,
	shortcut_choice_exp = 2,
	exp_fade_out_style = 1,
	exp_color = 14,
	specialkilled_color = 2,
	disable_hud_effects = false,
	anim_choice_style = 2
}

local function round(num, decimals)
	decimals = math.pow(10, decimals or 0)
	num = num * decimals

	if num >= 0 then
		 num = math.floor(num + 0.5)
	else
 		num = math.ceil(num - 0.5)
	end

	return num / decimals
end

local function UpdateOptions(args, no_delay, multi_thread)
    local function process_option(entry)
        if entry and entry.menu_name and entry.item_id and entry.option ~= nil then
            local menu = MenuHelper:GetMenu(entry.menu_name)
            if menu then
                for _, item in pairs(menu._items_list or {}) do
                    if item:name() == entry.item_id then
                        item:set_enabled(entry.option)
                    end
                end
            end
        end
    end

    local delay = no_delay and 0 or 0.1

    if multi_thread then
        for _, entry in pairs(args) do
            DelayedCalls:Add("Enabling/Disabling" .. (entry.item_id or ""), delay, function()
                process_option(entry)
            end)
        end
    else
        DelayedCalls:Add("Enabling/Disabling", delay, function()
            for _, entry in pairs(args) do
                process_option(entry)
            end
        end)
    end
end

function EXPOK:Save()
	local file = io.open( self._data_path, "w+" )
	if file then
		file:write( json.encode( self._data ) )
		file:close()
	end
end

function EXPOK:Load()
	local file = io.open( self._data_path, "r" )
	if file then
		self._data = json.decode( file:read("*all") )
		file:close()
	end
end

Hooks:Add("MenuManagerInitialize", "MenuManagerInitializeEXPOK", function(menu_manager)
	EXPOK:Load()
	MenuCallbackHandler.callback_EXPOK_show_announcer = function(self,item)
		local value = item:value() == "on"
		EXPOK._data.show_announcer = value
		EXPOK:Save()
	end
	MenuCallbackHandler.callback_EXPOK_disable_hud_effects = function(self,item)
		local value = item:value() == "on"
		EXPOK._data.disable_hud_effects = value
		EXPOK:Save()
	end
	MenuCallbackHandler.anim_choice_style_exp_callback = function(self,item)
		local value = item:value()
		EXPOK._data.anim_choice_style = value
		local items = {
			"shortcut_choice_exp",
			"EXPOK_show_announcer",
			"kln_adjust_x_change",
			"kln_adjust_y_change",
			"kln_font_size_change",
			"kln_duration_change",
			"exp_fade_out_style"
		}

		if value == 2 then
			for _, itemid in pairs(items) do
				UpdateOptions({
					{ menu_name = "EXPOK_menu", item_id = itemid, option = false },
				}, false, true)
			end
		else
			for _, itemid in pairs(items) do
				UpdateOptions({
					{ menu_name = "EXPOK_menu", item_id = itemid, option = true },
				}, false, true)
			end
		end

		EXPOK:Save()
	end
	MenuCallbackHandler.exp_text_duration_change_callback = function(self,item)
		local value = item:value()
		EXPOK._data.exp_text_duration = value
		EXPOK:Save()
	end
	MenuCallbackHandler.kln_duration_change_callback = function(self,item)
		local value = item:value()
		EXPOK._data.kln_duration = value
		EXPOK:Save()
	end
	MenuCallbackHandler.exp_font_size_change_callback = function(self,item)
		local value = round(item:value())
		EXPOK._data.exp_font_size = value
		EXPOK:Save()
	end
	MenuCallbackHandler.kln_font_size_change_callback = function(self,item)
		local value = round(item:value())
		EXPOK._data.kln_font_size = value
		EXPOK:Save()
	end
	MenuCallbackHandler.exp_adjust_x_change_callback = function(self,item)
		local value = item:value()
		EXPOK._data.exp_adjust_x = value
		EXPOK:Save()
	end
	MenuCallbackHandler.exp_adjust_y_change_callback = function(self,item)
		local value = item:value()
		EXPOK._data.exp_adjust_y = value
		EXPOK:Save()
	end
	MenuCallbackHandler.kln_adjust_x_change_callback = function(self,item)
		local value = item:value()
		EXPOK._data.kln_adjust_x = value
		EXPOK:Save()
	end
	MenuCallbackHandler.kln_adjust_y_change_callback = function(self,item)
		local value = item:value()
		EXPOK._data.kln_adjust_y = value
		EXPOK:Save()
	end
	MenuCallbackHandler.callback_EXPOK_gain_exp_on_kills = function(self,item)
		local value = item:value() == "on"
		EXPOK._data.gain_exp_on_kills = value
		EXPOK:Save()
	end
	MenuCallbackHandler.shortcut_choice_exp_callback = function(self,item)
		local value = item:value()
		EXPOK._data.shortcut_choice_exp = value
		EXPOK:Save()
	end
	MenuCallbackHandler.exp_fade_out_style_callback = function(self,item)
		local value = item:value()
		EXPOK._data.exp_fade_out_style = value
		EXPOK:Save()
	end
	MenuCallbackHandler.exp_color_change_callback = function(self,item)
		local value = item:value()
		EXPOK._data.exp_color = value
		EXPOK:Save()
	end
	MenuCallbackHandler.specialkilled_color_change_callback = function(self,item)
		local value = item:value()
		EXPOK._data.specialkilled_color = value
		EXPOK:Save()
	end
	MenuCallbackHandler.EXPOK_closed = function(self)
		EXPOK:Save()
	end

	EXPOK:Load()

	local items = {
		"shortcut_choice_exp",
		"EXPOK_show_announcer",
		"kln_adjust_x_change",
		"kln_adjust_y_change",
		"kln_font_size_change",
		"kln_duration_change",
		"exp_fade_out_style"
	}

	if EXPOK._data.anim_choice_style == 2 then
		for _, itemid in pairs(items) do
			UpdateOptions({
				{ menu_name = "EXPOK_menu", item_id = itemid, option = false },
			}, false, true)
		end
	else
		for _, itemid in pairs(items) do
			UpdateOptions({
				{ menu_name = "EXPOK_menu", item_id = itemid, option = true },
			}, false, true)
		end
	end

	MenuHelper:LoadFromJsonFile(EXPOK._path .. "menu/options.txt", EXPOK, EXPOK._data)
end)